function [f_vec1,g_vec1,time_vec1,e_vec1,matrix1] = IBCG (fun_f, grad_f_y,grad_f_x, grad_g_y,...
    grad_g_yx,grad_g_yy,param,X_0, Y_0, X_hat_r)
disp('IBCG Algorithm starts');
%------------------------parameter definition------------------------------
O_indx1_r = param.ind;
a = param.a;
alpha= param.alpha;
eta= param.eta;
gamma = param.gam;
maxiter = param.maxiter;

%initialization
x= vec(X_0);
y= vec(Y_0);
[n,m] = size(X_0);


tic;
% -------------------------IBCG algorithm----------------------------------
iter = 0;
f_vec1 = [];
g_vec1 = [];
e_vec1 = [];
time_vec1 = [];
w = zeros(n*m,1) ;

while iter <= maxiter
    iter = iter+1;
    w = eta* grad_f_y(x,y)+ (speye(n*m,n*m) -eta*grad_g_yy(y))*w;
    F = grad_f_x(x,y) - (grad_g_yx*w);
    
   %------------------------------Find s ----------------------------------
    F = reshape(F,[n m]);
   [v,d] = eigs(F,1,'smallestreal');
   if d<0
       s = a*(v*v');
   else
       s = 0*(v*v');
   end
   s = s(:);
   
   %-----------------------------------------------------------------------
    x = (1-gamma)*x + gamma*s; %update of x
    y = y - (alpha*grad_g_y(x,y)); %update of y

    %normalized error
    e1 = (sum(((x.* O_indx1_r - X_hat_r.* O_indx1_r).^2)))/ (sum((X_hat_r.* O_indx1_r).^2));

    cpu_t1 = toc;
    f_vec1 = [f_vec1;fun_f(x,y)];
    g_vec1 = [g_vec1;norm(grad_g_y(x,y))];
    e_vec1 = [e_vec1;e1];
    time_vec1 = [time_vec1;cpu_t1];
    if cpu_t1>param.maxtime
        break;
    end
end
matrix1 =x;
end